;
;								EJEMPLO 39
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006

		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos
  
;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC
  
;ADIVINA EL NUMERO: Ejemplo de entretenimiento consistente en adivinar un nmero
;aleatorio generado por el PIC. Se emplea la pantalla LCD y el teclado y se disponen
;una serie de oportunidades.

Lcd_var		equ	0x20		;Inicio de variables de las rutinas LCD
Key_var		equ	0x22		;Inicio de variables para rutinas de manejo del teclado
Temporal_1	equ	0x28
Temporal_2	equ	0x29		;Variables temporales de propsito general
Delay_var	equ	0x2a		;Variable de temporizacin
BCD_L		equ	0x2b		;Parte baja del nmero decimal aleatorio
BCD_H		equ	0x2c		;Parte baja del nmero decimal aleatorio
N_tecleado	equ	0x2d		;Nmero tecleado
Intentos	equ	0x2e		;Variable con el nmero de intentos
N_minimo	equ	0x2f
N_maximo	equ	0x30		;Variables con los lmites mnimo y mximo del N

				org	0x00		;Vector de RESET	
				goto	Inicio
				org	0x05
	
;*********************************************************************************************
;Tabla_Mensajes: Segn el valor contenido en el registro W, se devuelve el carcter a visualizar

Tabla_Mensajes	movwf	PCL		;Calcula el desplazamiento sobre la tabla

;La directiva dt genera tantas instrucciones RETLW como bytes o caracteres contenga

Mens_1		equ	$		;Mens_1 apunta al 1er. carcter del mensaje 1
			dt	" ADIVINA El N",0xdf,0x00
Mens_2		equ	$		
			dt	" (C) Continuar",0x00
Mens_3		equ	$
			dt	"Entre ",0x00
Mens_4		equ	$
			dt	"Teclea N",0xdf," ",0x00
Mens_5		equ	$
			dt	"Error, es menor",0x00
Mens_6		equ	$
			dt	"Error, es mayor",0x00
Mens_7		equ	$
			dt	"!oooh! GAME OVER",0x00
Mens_8		equ	$
			dt	"!! ACERTASTE !!",0x00

		include "TECLADO.INC"	;Incluye rutinas de manejo del teclado
		include	"LCD_CXX.INC"	;Incluye rutinas de manejo del LCD

;*********************************************************************************************
;Mensaje: Esta rutina enva a la pantalla LCD una cadena de caracteres. El inicio de dicha 
;cadena debe estar indicado en el reg. W. Toda cadena debe finalizar con el cdigo 0x00

Mensaje		movwf	Temporal_1		;Salva el ndice que apunta a la tabla de caracteres
Mensaje_1	movf	Temporal_1,W	;Recupera el ndice
			call	Tabla_Mensajes	;Busca el carcter a visualizar
			movwf	Temporal_2		;Salva el carcter a visualizar
			movf	Temporal_2,F
			btfss	STATUS,Z		;Mira si es el ltimo (0x00)
			goto	Mensaje_2		;No
			return					;Si
Mensaje_2	call	LCD_DATO		;Visualiza el carcter sobre el LCD
			incf	Temporal_1,F	;Incrementa el ndice para buscar el siguiente carcter
			goto	Mensaje_1

;**********************************************************************************************
;BIN_BCD: Convierte un valor binario presente en el acumulador (W) en tres dgitos BCD. El 
;dgito de ms peso se deja en la variable BCD_H y los dos de menos peso en BCD_L.

BIN_BCD		clrf	BCD_H
			clrf	BCD_L			;Borra resultados anteriores
BIN_BCD_1	addlw	0xf6			;Resta 10 mediante suma de complemento a 2
			btfss	STATUS,C		;Hay carry ?
			goto	BIN_BCD_3		;No
			movwf	Temporal_1		;Si, guarda el resultado remporalmente
			incf	BCD_L,F			;Ajustar el valor de BCD_L
			movf	BCD_L,W
			xorlw	0x0a
			btfss	STATUS,Z		;BCD_L mayor de 9 ??
			goto	BIN_BCD_2		;No
			clrf	BCD_L			;Si pone a 0 BCD_L
			incf	BCD_H,F			;Ajusta el valor de BCD_H
BIN_BCD_2	movf	Temporal_1,W	;Recupera resultado temporal
			goto	BIN_BCD_1
BIN_BCD_3	addlw	0x0a
			swapf	BCD_L,F
			iorwf	BCD_L,F
			return

;**********************************************************************************************
;BCD_ASCII: Esta rutina convierte el cdogo BCD de la tecla pulsada y presente en la variable
;"Tecla", en su correspondiente cdigo ASCII, para visualizarlo sobre el LCD.

BCD_ASCII	movf	Tecla,W		;Lee el cdigo BCD de la tecla pulsada
			sublw	.9
			btfss	STATUS,C	;Es mayor que 9 (A, B, C, D, E, F) ?
			goto	BCD_ASCII_1	;Si
			movf	Tecla,W		;No
			addlw	0x30		;Ajuste ASCII de los caracteres del 0 al 9
			goto	BCD_ASCII_2
BCD_ASCII_1	movf	Tecla,W
			addlw	0x37		;Ajuste ASCII de los caracteres de la A a la F
BCD_ASCII_2	call	LCD_DATO	;Visualiza sobre la posicin actual del cursor del LCD
			return

;*********************************************************************************************
;BIN_ASCII:Convierte un valor de 8 bits presente en W y los convierte a dos caracteres ASCII
;para visualizarlos sobre la posicin actual del cursor del LCD

BIN_ASCII	movwf	Temporal_1	;Salva el nmero binario
			swapf	Temporal_1,W
			andlw	0x0f
			iorlw	0x30		;Convierte a ASCII el nible de ms peso	
			call	LCD_DATO	;Visualiza
			movf	Temporal_1,W
			andlw	0x0f
			iorlw	0x30		;Convierte a ASCII el nible de menos peso
			call	LCD_DATO	;Visualiza
			return

;*******************************************************************************************
;Wait_tecla: Espera a que se pulse (y suelte) una tecla vlida y se visualiza
		
Wait_tecla	clrwdt
			call	Key_Scan	;Explora el teclado
			btfsc	Tecla,7		;Hay alguna pulsada ?
			goto	Wait_tecla	;No
			movlw	0x0a		;Si
			subwf	Tecla,w
			btfsc	STATUS,C	;Mayor de 9 ??
			goto	Wait_tecla	;Si, no vale
			movf	Tecla,W
			movwf	Temporal_1	;Salva la tecla pulsada
			call	BCD_ASCII	;No, visualiza la pulsacin
	
Wait_tecla_1	clrwdt
				call	Key_Scan	;Explora el teclado
				btfss	Tecla,7		;Se ha soltado ??
				goto	Wait_tecla_1	;Todava no
				return

;Iniciar E/S y pantalla LCD

Inicio	   	bsf		STATUS,RP0	;Selecciona banco 1
			movlw	b'00000110'
			movwf	ADCON1		;Puerta A E/S digitales
			clrf	TRISB		;Puerta B se configura como salida
			clrf	TRISA		;Puerta A se configura como salida
			movlw	b'000000111'	
			movwf	OPTION_REG	;Preescaler de 256 para el TMR0
			bcf		STATUS,RP0	;Selecciona banco 0

			call	UP_LCD		;Configura puerto para el LCD
			call	LCD_INI		;Inicia el LCD
			movlw	b'00001100'
			call	LCD_REG		;LCD On, cursor y blink Off

;Bucle principal, se inician las variables de juego y mensaje de bienvenida

Bucle		movlw	0x01
			call	LCD_REG		;Borra pantalla e inicia el cursor
			movlw	.5
			movwf	Intentos	;Carga el nmero de intentos posible
			movlw	0x99
			movwf	N_maximo
			clrf	N_minimo	;Inicia valores mximos y mnimos (00 y 99)
			movlw	Mens_1
			call	Mensaje		;Visualiza mensaje de inicio N 1
			movlw	0xc0
			call	LCD_REG
			movlw	Mens_2
			call 	Mensaje		;Visualiza mensaje de inicio N 2

;Espera que se pulse y se suelte la tecla C para capturar un nmero aleatorio y comenzar la
;partida

Pulsar_C_1	clrwdt				;Refresco del WDT
			call	Key_Scan	;explora el teclado
			btfsc	Tecla,7		;Hay alguna tecla pulsada ??
			goto	Pulsar_C_1	;No
			movlw	0x0c
			subwf	Tecla,W
			btfss	STATUS,Z	;Ha sido la C de continuar ??
			goto	Pulsar_C_1
			movf	TMR0,W
			call	BIN_BCD		;Captura N aleatorio y convierte a BCD
Pulsar_C_2	clrwdt
			call	Key_Scan	;Explora el teclado
			btfss	Tecla,7		;Se ha soltado ??
			goto	Pulsar_C_2	;Todava no

;Presenta la pantalla de juego 

Intento		movlw	0x01
			call	LCD_REG		;Borra pantalla e inicia el cursor
			movlw	Mens_3
			call	Mensaje		;Visualiza mensaje 3
			movf	N_minimo,W
			call	BIN_ASCII	;Visualiza el nmero mnimo
			movlw	'-'
			call	LCD_DATO
			movf	N_maximo,W
			call	BIN_ASCII	;Visualiza el nmero mximo
			movlw	0x8e
			call	LCD_REG		;Coloca cursor
			movf	Intentos,W
			call	BIN_ASCII	;Visualiza contador de intentos
			movlw	0xc0
			call	LCD_REG		;Coloca el cursor
			movlw	Mens_4
			call	Mensaje		;Visualiza mensaje 4

;Espera que se pulsen dos teclas BCD, se visualizan y se compone el nmero teclado por el jugador

			call	Wait_tecla	;Espera la primera pulsacin
			swapf	Temporal_1,W
			movwf	N_tecleado	;Recupera el 1er. dgito tecleado
			call	Wait_tecla
			movf	Temporal_1,W
			iorwf	N_tecleado,F	;Recupera 2 dgito y compone el n tecleado

;Determina si el N tecleado es mayor, menor o igual al aleatorio
		
			movf	BCD_L,W
			subwf	N_tecleado,W
			btfsc	STATUS,Z	;Es igual ??
			goto	Igual		;Si
			btfss	STATUS,C	;Es mayor ??
			goto	Menor		;No, es menor

Mayor		movf	N_tecleado,W
			movwf	N_maximo	;Ajusta nuevo n mximo
			movlw	0x01
			call	LCD_REG		;Borra pantalla e inicia el cursor
			movlw	Mens_5
			call	Mensaje		;Visualiza mensaje 5	
			goto	Fallo
Menor		movf	N_tecleado,W
			movwf	N_minimo
			movlw	0x01
			call	LCD_REG		;Borra pantalla e inicia el cursor
			movlw	Mens_6
			call	Mensaje		;Visualiza mensaje 6
Fallo		movlw	.4
			movwf	Temporal_1	;N de veces de la secuencia Beep de fallo y delay

Fallo_1		movlw	.35
			movwf	Delay_var
			call	Delay_10m	;Delay de 1 "
			decfsz	Temporal_1,F
			goto	Fallo_1
			decfsz	Intentos,F	;Decrementa el contador de intentos
			goto	Intento		;Repite la secuencia con otro nuevo intento

			movlw	0x01
			call	LCD_REG		;Borra la pantalla e inicia el cursor
			movlw	Mens_7
			call	Mensaje		;Visualiza mensaje 7
			movlw	.200
			movwf	Delay_var
			call	Delay_10m	;Temporizacin de 1"
			goto	Bucle		;Nueva partida

Igual		movlw	0x01
			call	LCD_REG		;Borra pantalla e inicia el cursor
			movlw	Mens_8
			call	Mensaje		;Visualiza mensaje 8
			movlw	.200
			movwf	Delay_var
			call	Delay_10m	;Temporiza 2"
			goto	Bucle	


;*********************************************************************************************
;Delay_10m: Realiza una temporizacin de 10mS mediante el TMR0 (con preescaler de 256) que se 
;repite tantas veces como indique la variable Delay_var

Delay_10m	bcf		INTCON,T0IF
			movlw	~.39
			movwf	TMR0
Delay_10m_1	btfss	INTCON,T0IF
			goto	Delay_10m_1		
			decfsz	Delay_var,F	;Se ha repetido el nmero de veces deseado
			goto	Delay_10m	;No, esperar otros 18 mS
			return				;Si

			end

